#include "filerecorddlg.h"
#include "ui_filerecorddlg.h"
#include "mainwindow.h"

FileRecordDlg::FileRecordDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FileRecordDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("FILE RECORD DIALOG");

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->BTN_StopRecord11->setEnabled(false);

    ui->BTN_StopRecord12->setEnabled(false);

    ui->BTN_StopRecord21->setEnabled(false);

    ui->BTN_StopRecord22->setEnabled(false);

    ui->BTN_StopRecord31->setEnabled(false);

    ui->BTN_StopRecord32->setEnabled(false);

    ui->BTN_StopRecord41->setEnabled(false);

    ui->BTN_StopRecord42->setEnabled(false);

    ui->checkBox_AVI11->setChecked(false);

    ui->checkBox_AVI12->setChecked(false);

    ui->checkBox_AVI21->setChecked(false);

    ui->checkBox_AVI22->setChecked(false);

    ui->checkBox_AVI31->setChecked(false);

    ui->checkBox_AVI32->setChecked(false);

    ui->checkBox_AVI41->setChecked(false);

    ui->checkBox_AVI42->setChecked(false);

    ui->checkBox_MP411->setChecked(true);

    ui->checkBox_MP412->setChecked(true);

    ui->checkBox_MP421->setChecked(true);

    ui->checkBox_MP422->setChecked(true);

    ui->checkBox_MP431->setChecked(true);

    ui->checkBox_MP432->setChecked(true);

    ui->checkBox_MP441->setChecked(true);

    ui->checkBox_MP442->setChecked(true);

    ui->checkBox_GPU11->setEnabled(false);

    ui->checkBox_GPU21->setEnabled(false);

    ui->checkBox_GPU31->setEnabled(false);

    ui->checkBox_GPU41->setEnabled(false);

    ui->RecordPath11->setText( SC540dlg->path + QString("/record_1_1.mp4"));

    ui->RecordPath12->setText( SC540dlg->path + QString("/record_1_2.mp4"));

    ui->RecordPath21->setText( SC540dlg->path + QString("/record_2_1.mp4"));

    ui->RecordPath22->setText( SC540dlg->path + QString("/record_2_2.mp4"));

    ui->RecordPath31->setText( SC540dlg->path + QString("/record_3_1.mp4"));

    ui->RecordPath32->setText( SC540dlg->path + QString("/record_3_2.mp4"));

    ui->RecordPath41->setText( SC540dlg->path + QString("/record_4_1.mp4"));

    ui->RecordPath42->setText( SC540dlg->path + QString("/record_4_2.mp4"));

    if( SC540dlg->m_hVideoDevice[0] == 0)
    {
        ui->BTN_StartRecord11->setEnabled(false);

        ui->BTN_StartRecord12->setEnabled(false);
    }

    if( SC540dlg->m_hVideoDevice[1] == 0)
    {
        ui->BTN_StartRecord21->setEnabled(false);

        ui->BTN_StartRecord22->setEnabled(false);
    }

    if( SC540dlg->m_hVideoDevice[2] == 0)
    {
        ui->BTN_StartRecord31->setEnabled(false);

        ui->BTN_StartRecord32->setEnabled(false);
    }

    if( SC540dlg->m_hVideoDevice[3] == 0)
    {
        ui->BTN_StartRecord41->setEnabled(false);

        ui->BTN_StartRecord42->setEnabled(false);
    }

}

FileRecordDlg::~FileRecordDlg()
{
    delete ui;
}

void FileRecordDlg::on_BTN_StartRecord11_clicked()
{
    // Start to Record Channel 1 with Slot 0

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[0], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    if ( ui->checkBox_AVI11->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[0], 0, ui->RecordPath11->text().toLatin1().data());

    ui->BTN_StartRecord11->setEnabled(false);

    ui->BTN_StopRecord11->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord11_clicked()
{
    // Stop to Record Channel 1 with Slot 0

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[0], 0 );

    ui->BTN_StartRecord11->setEnabled(true);

    ui->BTN_StopRecord11->setEnabled(false);
}

void FileRecordDlg::on_BTN_StartRecord12_clicked()
{
    // Start to Record Channel 1 with Slot 1

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if ( ui->checkBox_GPU12->isChecked() ) {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    } else {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    if ( ui->checkBox_AVI12->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[0], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[0], 1, ui->RecordPath12->text().toLatin1().data());

    ui->BTN_StartRecord12->setEnabled(false);

    ui->BTN_StopRecord12->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord12_clicked()
{
    // Stop to Record Channel 1 with Slot 1

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[0], 1 );

    ui->BTN_StartRecord12->setEnabled(true);

    ui->BTN_StopRecord12->setEnabled(false);
}

void FileRecordDlg::on_BTN_StartRecord21_clicked()
{
    // Start to Record Channel 2 with Slot 1

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[1], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    if ( ui->checkBox_AVI21->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[1], 0, ui->RecordPath21->text().toLatin1().data());

    ui->BTN_StartRecord21->setEnabled(false);

    ui->BTN_StopRecord21->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord21_clicked()
{
    // Stop to Record Channel 2 with Slot 1

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[1], 0 );

    ui->BTN_StartRecord21->setEnabled(true);

    ui->BTN_StopRecord21->setEnabled(false);
}

void FileRecordDlg::on_BTN_StartRecord22_clicked()
{
    // Start to Record Channel 2 with Slot 2

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if ( ui->checkBox_GPU22->isChecked() ) {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    } else {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    if ( ui->checkBox_AVI22->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[1], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[1], 1, ui->RecordPath22->text().toLatin1().data());

    ui->BTN_StartRecord22->setEnabled(false);

    ui->BTN_StopRecord22->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord22_clicked()
{
    // Stop to Record Channel 2 with Slot 2

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[1], 1 );

    ui->BTN_StartRecord22->setEnabled(true);

    ui->BTN_StopRecord22->setEnabled(false);
}

void FileRecordDlg::on_BTN_StartRecord31_clicked()
{
    // Start to Record Channel 3 with Slot 1

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[2], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    if ( ui->checkBox_AVI31->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[2], 0, ui->RecordPath31->text().toLatin1().data());

    ui->BTN_StartRecord31->setEnabled(false);

    ui->BTN_StopRecord31->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord31_clicked()
{
    // Stop to Record Channel 3 with Slot 1

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[2], 0 );

    ui->BTN_StartRecord31->setEnabled(true);

    ui->BTN_StopRecord31->setEnabled(false);
}

void FileRecordDlg::on_BTN_StartRecord32_clicked()
{
    // Start to Record Channel 3 with Slot 2

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if ( ui->checkBox_GPU32->isChecked() ) {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    } else {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    if ( ui->checkBox_AVI32->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[2], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[2], 1, ui->RecordPath32->text().toLatin1().data());

    ui->BTN_StartRecord32->setEnabled(false);

    ui->BTN_StopRecord32->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord32_clicked()
{
    // Stop to Record Channel 3 with Slot 2

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[2], 1 );

    ui->BTN_StartRecord32->setEnabled(true);

    ui->BTN_StopRecord32->setEnabled(false);
}

void FileRecordDlg::on_BTN_StartRecord41_clicked()
{
    // Start to Record Channel 4 with Slot 1

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[3], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    if ( ui->checkBox_AVI41->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[3], 0, ui->RecordPath41->text().toLatin1().data());

    ui->BTN_StartRecord41->setEnabled(false);

    ui->BTN_StopRecord41->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord41_clicked()
{
    // Stop to Record Channel 4 with Slot 2

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[3], 0 );

    ui->BTN_StartRecord41->setEnabled(true);

    ui->BTN_StopRecord41->setEnabled(false);
}

void FileRecordDlg::on_BTN_StartRecord42_clicked()
{
    // Start to Record Channel 4 with Slot 2

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    if ( ui->checkBox_GPU42->isChecked() ) {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

    } else {

        QCAP_SET_VIDEO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    if ( ui->checkBox_AVI42->isChecked() ) {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

    } else {

        QCAP_SET_AUDIO_RECORD_PROPERTY( SC540dlg->m_hVideoDevice[3], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }

    QCAP_START_RECORD( SC540dlg->m_hVideoDevice[3], 1, ui->RecordPath42->text().toLatin1().data());

    ui->BTN_StartRecord42->setEnabled(false);

    ui->BTN_StopRecord42->setEnabled(true);
}

void FileRecordDlg::on_BTN_StopRecord42_clicked()
{
    // Stop to Record Channel 4 with Slot 2

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    QCAP_STOP_RECORD( SC540dlg->m_hVideoDevice[3], 1 );

    ui->BTN_StartRecord42->setEnabled(true);

    ui->BTN_StopRecord42->setEnabled(false);
}

void FileRecordDlg::on_checkBox_AVI11_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath11->setText( SC540dlg->path + QString("/record_1_1.avi"));

    ui->checkBox_AVI11->setChecked(true);

    ui->checkBox_MP411->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP411_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath11->setText( SC540dlg->path + QString("/record_1_1.mp4"));

    ui->checkBox_AVI11->setChecked(false);

    ui->checkBox_MP411->setChecked(true);
}

void FileRecordDlg::on_checkBox_AVI12_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath12->setText( SC540dlg->path + QString("/record_1_2.avi"));

    ui->checkBox_AVI12->setChecked(true);

    ui->checkBox_MP412->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP412_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath12->setText( SC540dlg->path + QString("/record_1_2.mp4"));

    ui->checkBox_AVI12->setChecked(false);

    ui->checkBox_MP412->setChecked(true);
}

void FileRecordDlg::on_checkBox_AVI21_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath21->setText( SC540dlg->path + QString("/record_2_1.avi"));

    ui->checkBox_AVI21->setChecked(true);

    ui->checkBox_MP421->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP421_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath21->setText( SC540dlg->path + QString("/record_2_1.mp4"));

    ui->checkBox_AVI21->setChecked(false);

    ui->checkBox_MP421->setChecked(true);
}

void FileRecordDlg::on_checkBox_AVI22_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath22->setText( SC540dlg->path + QString("/record_2_2.avi"));

    ui->checkBox_AVI22->setChecked(true);

    ui->checkBox_MP422->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP422_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath22->setText( SC540dlg->path + QString("/record_2_2.mp4"));

    ui->checkBox_AVI22->setChecked(false);

    ui->checkBox_MP422->setChecked(true);
}

void FileRecordDlg::on_checkBox_AVI31_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath31->setText( SC540dlg->path + QString("/record_3_1.avi"));

    ui->checkBox_AVI31->setChecked(true);

    ui->checkBox_MP431->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP431_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath31->setText( SC540dlg->path + QString("/record_3_1.mp4"));

    ui->checkBox_AVI31->setChecked(false);

    ui->checkBox_MP431->setChecked(true);
}

void FileRecordDlg::on_checkBox_AVI32_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath32->setText( SC540dlg->path + QString("/record_3_2.avi"));

    ui->checkBox_AVI32->setChecked(true);

    ui->checkBox_MP432->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP432_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath32->setText( SC540dlg->path + QString("/record_3_2.mp4"));

    ui->checkBox_AVI32->setChecked(false);

    ui->checkBox_MP432->setChecked(true);
}

void FileRecordDlg::on_checkBox_AVI41_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath41->setText( SC540dlg->path + QString("/record_4_1.avi"));

    ui->checkBox_AVI41->setChecked(true);

    ui->checkBox_MP441->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP441_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath41->setText( SC540dlg->path + QString("/record_4_1.mp4"));

    ui->checkBox_AVI41->setChecked(false);

    ui->checkBox_MP441->setChecked(true);
}

void FileRecordDlg::on_checkBox_AVI42_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath42->setText( SC540dlg->path + QString("/record_4_2.avi"));

    ui->checkBox_AVI42->setChecked(true);

    ui->checkBox_MP442->setChecked(false);
}

void FileRecordDlg::on_checkBox_MP442_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ui->RecordPath42->setText( SC540dlg->path + QString("/record_4_2.mp4"));

    ui->checkBox_AVI42->setChecked(false);

    ui->checkBox_MP442->setChecked(true);
}
